/*
 * Decompiled with CFR 0.152.
 */
package sleep.bridges;

import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import sleep.bridges.BridgeUtilities;
import sleep.interfaces.Function;
import sleep.interfaces.Loadable;
import sleep.interfaces.Predicate;
import sleep.parser.ParserConfig;
import sleep.runtime.Scalar;
import sleep.runtime.ScriptEnvironment;
import sleep.runtime.ScriptInstance;
import sleep.runtime.SleepUtils;
import sleep.taint.TaintUtils;

public class RegexBridge
implements Loadable {
    private static Map patternCache = Collections.synchronizedMap(new Cache(128));

    private static Pattern getPattern(String string) {
        Pattern pattern = (Pattern)patternCache.get(string);
        if (pattern != null) {
            return pattern;
        }
        pattern = Pattern.compile(string);
        patternCache.put(string, pattern);
        return pattern;
    }

    public void scriptUnloaded(ScriptInstance scriptInstance) {
    }

    public void scriptLoaded(ScriptInstance scriptInstance) {
        Hashtable hashtable = scriptInstance.getScriptEnvironment().getEnvironment();
        isMatch isMatch2 = new isMatch();
        hashtable.put("ismatch", isMatch2);
        hashtable.put("hasmatch", isMatch2);
        hashtable.put("&matched", isMatch2);
        hashtable.put("&split", new split());
        hashtable.put("&join", new join());
        hashtable.put("&matches", new getMatches());
        hashtable.put("&replace", new rreplace());
        hashtable.put("&find", new ffind());
    }

    private static String key(String string, Pattern pattern) {
        StringBuffer stringBuffer = new StringBuffer(string.length() + pattern.pattern().length() + 1);
        stringBuffer.append(string);
        stringBuffer.append(pattern.pattern());
        return stringBuffer.toString();
    }

    private static Scalar getLastMatcher(ScriptEnvironment scriptEnvironment) {
        Scalar scalar = (Scalar)scriptEnvironment.getContextMetadata("matcher");
        return scalar == null ? SleepUtils.getEmptyScalar() : scalar;
    }

    private static Scalar getMatcher(ScriptEnvironment scriptEnvironment, String string, String string2, Pattern pattern) {
        Scalar scalar;
        Map map2 = (Map)scriptEnvironment.getContextMetadata("matchers");
        if (map2 == null) {
            map2 = new Cache(16);
            scriptEnvironment.setContextMetadata("matchers", map2);
        }
        if ((scalar = (Scalar)map2.get(string)) == null) {
            scalar = SleepUtils.getScalar(pattern.matcher(string2));
            map2.put(string, scalar);
            return scalar;
        }
        return scalar;
    }

    static {
        ParserConfig.addKeyword("ismatch");
        ParserConfig.addKeyword("hasmatch");
    }

    private static class rreplace
    implements Function {
        private rreplace() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            String string2 = BridgeUtilities.getString(stack, "");
            String string3 = BridgeUtilities.getString(stack, "");
            String string4 = BridgeUtilities.getString(stack, "");
            int n = BridgeUtilities.getInt(stack, -1);
            StringBuffer stringBuffer = new StringBuffer();
            Pattern pattern = RegexBridge.getPattern(string3);
            Matcher matcher = pattern.matcher(string2);
            for (int i = 0; matcher.find() && i != n; ++i) {
                matcher.appendReplacement(stringBuffer, string4);
            }
            matcher.appendTail(stringBuffer);
            return SleepUtils.getScalar(stringBuffer.toString());
        }
    }

    private static class join
    implements Function {
        private join() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            String string2 = ((Scalar)stack.pop()).toString();
            Iterator iterator = BridgeUtilities.getIterator(stack, scriptInstance);
            StringBuffer stringBuffer = new StringBuffer();
            if (iterator.hasNext()) {
                stringBuffer.append(iterator.next().toString());
            }
            while (iterator.hasNext()) {
                stringBuffer.append(string2);
                stringBuffer.append(iterator.next().toString());
            }
            return SleepUtils.getScalar(stringBuffer.toString());
        }
    }

    private static class split
    implements Function {
        private split() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            String string2 = ((Scalar)stack.pop()).toString();
            String string3 = ((Scalar)stack.pop()).toString();
            Pattern pattern = RegexBridge.getPattern(string2);
            String[] stringArray = stack.isEmpty() ? pattern.split(string3) : pattern.split(string3, BridgeUtilities.getInt(stack, 0));
            Scalar scalar = SleepUtils.getArrayScalar();
            for (int i = 0; i < stringArray.length; ++i) {
                scalar.getArray().push(SleepUtils.getScalar(stringArray[i]));
            }
            return scalar;
        }
    }

    private static class getMatches
    implements Function {
        private getMatches() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            String string2 = ((Scalar)stack.pop()).toString();
            String string3 = ((Scalar)stack.pop()).toString();
            int n = BridgeUtilities.getInt(stack, -1);
            int n2 = BridgeUtilities.getInt(stack, n);
            Pattern pattern = RegexBridge.getPattern(string3);
            Matcher matcher = pattern.matcher(string2);
            Scalar scalar = SleepUtils.getArrayScalar();
            int n3 = 0;
            while (matcher.find()) {
                int n4 = matcher.groupCount();
                if (n3 == n) {
                    scalar = SleepUtils.getArrayScalar();
                }
                for (int i = 1; i <= n4; ++i) {
                    scalar.getArray().push(SleepUtils.getScalar(matcher.group(i)));
                }
                if (n3 == n2) {
                    return scalar;
                }
                ++n3;
            }
            return scalar;
        }
    }

    private static class isMatch
    implements Predicate,
    Function {
        private isMatch() {
        }

        public boolean decide(String string, ScriptInstance scriptInstance, Stack stack) {
            boolean bl;
            Scalar scalar = (Scalar)stack.pop();
            Scalar scalar2 = (Scalar)stack.pop();
            Pattern pattern = RegexBridge.getPattern(scalar.toString());
            Scalar scalar3 = null;
            Matcher matcher = null;
            if (string.equals("hasmatch")) {
                Map map2;
                String string2 = RegexBridge.key(scalar2.toString(), pattern);
                scalar3 = RegexBridge.getMatcher(scriptInstance.getScriptEnvironment(), string2, scalar2.toString(), pattern);
                matcher = (Matcher)scalar3.objectValue();
                bl = matcher.find();
                if (!bl && (map2 = (Map)scriptInstance.getScriptEnvironment().getContextMetadata("matchers")) != null) {
                    map2.remove(string2);
                }
            } else {
                matcher = pattern.matcher(scalar2.toString());
                scalar3 = SleepUtils.getScalar(matcher);
                bl = matcher.matches();
            }
            if (TaintUtils.isTainted(scalar2) || TaintUtils.isTainted(scalar)) {
                TaintUtils.taintAll(scalar3);
            }
            scriptInstance.getScriptEnvironment().setContextMetadata("matcher", bl ? scalar3 : null);
            return bl;
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            Scalar scalar = SleepUtils.getArrayScalar();
            Scalar scalar2 = RegexBridge.getLastMatcher(scriptInstance.getScriptEnvironment());
            if (!SleepUtils.isEmptyScalar(scalar2)) {
                Matcher matcher = (Matcher)scalar2.objectValue();
                int n = matcher.groupCount();
                for (int i = 1; i <= n; ++i) {
                    scalar.getArray().push(SleepUtils.getScalar(matcher.group(i)));
                }
            }
            return TaintUtils.isTainted(scalar2) ? TaintUtils.taintAll(scalar) : scalar;
        }
    }

    private static class ffind
    implements Function {
        private ffind() {
        }

        public Scalar evaluate(String string, ScriptInstance scriptInstance, Stack stack) {
            int n;
            String string2 = BridgeUtilities.getString(stack, "");
            String string3 = BridgeUtilities.getString(stack, "");
            Pattern pattern = RegexBridge.getPattern(string3);
            Matcher matcher = pattern.matcher(string2);
            boolean bl = matcher.find(n = BridgeUtilities.normalize(BridgeUtilities.getInt(stack, 0), string2.length()));
            if (bl) {
                scriptInstance.getScriptEnvironment().setContextMetadata("matcher", SleepUtils.getScalar(matcher));
            } else {
                scriptInstance.getScriptEnvironment().setContextMetadata("matcher", null);
            }
            return bl ? SleepUtils.getScalar(matcher.start()) : SleepUtils.getEmptyScalar();
        }
    }

    private static class Cache
    extends LinkedHashMap {
        protected int count;

        public Cache(int n) {
            super(11, 0.75f, true);
            this.count = n;
        }

        protected boolean removeEldestEntry(Map.Entry entry) {
            return this.size() >= this.count;
        }
    }
}

