---
name: Pull Request Template
about: A template to help contributors submit clear pull-requests.
title: ''
labels: ''
assignees: ''

---

# Pull Request Details
<!--- The title of the PR should summarize the change implemented. -->
<!--- Example commit message format: -->
<!--- `module: summary of change` -->
<!--- (leave blank) -->
<!--- `details of what/why/how an issue was addressed` -->
<!--- Keep subject lines to 50 characters (but 72 is a hard limit!) -->
<!--- characters. Refer to the [Revision Control Guidelines](https://github.com/gnuradio/greps/blob/master/grep-0001-coding-guidelines.md#revision-control-guidelines) section of the coding guidelines -->

## Description
<!--- Provide a general summary of your changes in the title above -->
<!--- Why is this change required? What problem does it solve? -->

## Related Issue
<!--- Refer to any related issues here -->
<!--- If this PR fully addresses an issue, please say "Fixes #1234", -->
<!--- as this will allow Github to automatically close the related Issue -->

## Which blocks/areas does this affect?
<!--- Include blocks that are affected and some details on what -->
<!--- areas these changes affect, such as performance. -->

## Testing Done
<!--- Please describe in detail how you tested your changes. -->
<!--- Include details of your testing environment, and the tests you -->
<!--- ran to see how your change affects other areas of the code, -->
<!--- etc. Then, include justifications for how your tests -->
<!--- demonstrate those affects. -->

## Checklist
<!--- Go over all the following points, and put an `x` in all the
<!--- boxes that apply. Note that some of these may not be valid -->
<!--- for all PRs. -->

- [ ] I have read the [CONTRIBUTING document](https://github.com/gnuradio/gnuradio/blob/master/CONTRIBUTING.md).
- [ ] I have squashed my commits to have one significant change per commit. 
- [ ] I [have signed my commits before making this PR](https://github.com/gnuradio/gnuradio/blob/master/CONTRIBUTING.md#dco-signed)
- [ ] My code follows the code style of this project. See [GREP1.md](https://github.com/gnuradio/greps/blob/master/grep-0001-coding-guidelines.md).
- [ ] I have updated [the documentation](https://wiki.gnuradio.org/index.php/Main_Page#Documentation) where necessary.
- [ ] I have added tests to cover my changes, and all previous tests pass.
