-- Copyright 2004-2023 H2 Group. Multiple-Licensed under the MPL 2.0,
-- and the EPL 1.0 (https://h2database.com/html/license.html).
-- Initial Developer: H2 Group
--

CREATE TABLE TEST(T1 TIME, T2 TIME WITHOUT TIME ZONE);
> ok

INSERT INTO TEST(T1, T2) VALUES (TIME '10:00:00', TIME WITHOUT TIME ZONE '10:00:00');
> update count: 1

SELECT T1, T2, T1 = T2 FROM TEST;
> T1       T2       T1 = T2
> -------- -------- -------
> 10:00:00 10:00:00 TRUE
> rows: 1

SELECT COLUMN_NAME, DATA_TYPE FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_NAME = 'TEST' ORDER BY ORDINAL_POSITION;
> COLUMN_NAME DATA_TYPE
> ----------- ---------
> T1          TIME
> T2          TIME
> rows (ordered): 2

ALTER TABLE TEST ADD (T3 TIME(0), T4 TIME(9) WITHOUT TIME ZONE);
> ok

SELECT COLUMN_NAME, DATA_TYPE, DATETIME_PRECISION FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_NAME = 'TEST' ORDER BY ORDINAL_POSITION;
> COLUMN_NAME DATA_TYPE DATETIME_PRECISION
> ----------- --------- ------------------
> T1          TIME      0
> T2          TIME      0
> T3          TIME      0
> T4          TIME      9
> rows (ordered): 4

ALTER TABLE TEST ADD T5 TIME(10);
> exception INVALID_VALUE_SCALE

DROP TABLE TEST;
> ok

-- Check that TIME is allowed as a column name
CREATE TABLE TEST(TIME TIME);
> ok

INSERT INTO TEST VALUES (TIME '08:00:00');
> update count: 1

SELECT TIME FROM TEST;
>> 08:00:00

DROP TABLE TEST;
> ok

CREATE TABLE TEST(T TIME, T0 TIME(0), T1 TIME(1), T2 TIME(2), T3 TIME(3), T4 TIME(4), T5 TIME(5), T6 TIME(6),
    T7 TIME(7), T8 TIME(8), T9 TIME(9));
> ok

INSERT INTO TEST VALUES ('08:00:00.123456789', '08:00:00.123456789', '08:00:00.123456789', '08:00:00.123456789',
    '08:00:00.123456789', '08:00:00.123456789', '08:00:00.123456789', '08:00:00.123456789', '08:00:00.123456789',
    '08:00:00.123456789', '08:00:00.123456789');
> update count: 1

SELECT * FROM TEST;
> T        T0       T1         T2          T3           T4            T5             T6              T7               T8                T9
> -------- -------- ---------- ----------- ------------ ------------- -------------- --------------- ---------------- ----------------- ------------------
> 08:00:00 08:00:00 08:00:00.1 08:00:00.12 08:00:00.123 08:00:00.1235 08:00:00.12346 08:00:00.123457 08:00:00.1234568 08:00:00.12345679 08:00:00.123456789
> rows: 1

DELETE FROM TEST;
> update count: 1

INSERT INTO TEST(T0, T8) VALUES ('23:59:59.999999999', '23:59:59.999999999');
> update count: 1

SELECT T0 FROM TEST;
>> 23:59:59

SELECT T8 FROM TEST;
>> 23:59:59.99999999

DROP TABLE TEST;
> ok

SELECT TIME '11:22:33';
>> 11:22:33

SELECT TIME '11:22';
>> 11:22:00

SELECT TIME '112233';
>> 11:22:33

SELECT TIME '1122';
>> 11:22:00

SELECT TIME '12233';
> exception INVALID_DATETIME_CONSTANT_2

SELECT TIME '122';
> exception INVALID_DATETIME_CONSTANT_2

SELECT TIME '11:22:33.1';
>> 11:22:33.1

SELECT TIME '112233.1';
>> 11:22:33.1

SELECT TIME '12233.1';
> exception INVALID_DATETIME_CONSTANT_2

SELECT TIME '1122.1';
> exception INVALID_DATETIME_CONSTANT_2

SELECT CAST (TIMESTAMP '1000000000-12-31 11:22:33.123456789' AS TIME);
>> 11:22:33

SELECT CAST (TIMESTAMP '1000000000-12-31 11:22:33.123456789' AS TIME(9));
>> 11:22:33.123456789

SELECT CAST (TIMESTAMP '-1000000000-12-31 11:22:33.123456789' AS TIME(9));
>> 11:22:33.123456789

SELECT CAST (TIME '10:00:00' AS DATE);
> exception DATA_CONVERSION_ERROR_1
