# Contributing to Hubble

`hubble` is an open source project licensed under [Apache-2.0](LICENSE). Everybody is welcome to contribute. Contributors are required to follow the [CNCF Code of Conduct](https://github.com/cncf/foundation/blob/main/code-of-conduct.md).

## Getting Started

- Read the [README](https://github.com/cilium/hubble/blob/main/README.md) to understand how `hubble` works and its use cases.
- Check out the [issues list](https://github.com/cilium/hubble/issues) for open tasks, especially those labeled `good first issue`.

## Contribution workflow

Hubble uses GitHub for collaborative development. Note that this repository only hosts release artifacts for the Hubble CLI. The actual code for Hubble (CLI, server, Relay, metrics) is in the Cilium GitHub repository under [`hubble/`](https://github.com/cilium/cilium/tree/main/hubble), [`hubble-relay/`](https://github.com/cilium/cilium/tree/main/hubble-relay) and [`pkg/hubble/`](https://github.com/cilium/cilium/tree/main/pkg/hubble) directories. Please use GitHub issues to discuss proposals and use pull requests to suggest changes in Cilium GitHub repository.

For more information see the [Cilium Development Guide](https://docs.cilium.io/en/latest/contributing/development/) and the [Hubble-specific notes](https://docs.cilium.io/en/latest/contributing/development/hubble/).

## Contributor Ladder  

The Cilium project has a well-defined [contributor ladder](https://github.com/cilium/community/blob/main/CONTRIBUTOR-LADDER.md) to help community members grow both responsibilities and privileges in the project ecosystem. This ladder outlines the path from an occasional contributor to a committer, detailing expectations at each stage. Most contributors start at the community level in a sub-project and progress as they become more engaged in the project ecosystem. We encourage you to take an active role, and the community is here to support you on this journey.  

Becoming a [Cilium organization member](https://github.com/cilium/community/blob/main/CONTRIBUTOR-LADDER.md#organization-member) grants you additional privileges across the project ecosystem, such as the ability to leave reviews on a PR or trigger CI runs. If you're contributing regularly to `hubble`, consider joining the [hubble team](https://github.com/cilium/community/blob/main/ladder/teams/sig-hubble.yaml) to help review code and accelerate development. Your contributions play a vital role in improving the project, and we'd love to have you more involved!

## Community

Join the Cilium community for discussions:

Slack: [Cilium Slack](https://slack.cilium.io/) in #dev-hubble and #hubble

We appreciate your contributions to `hubble` and look forward to your involvement!
