/*
 * Decompiled with CFR 0.152.
 */
package javapayload.stage;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;

public class StreamForwarder
extends Thread {
    private final InputStream in;
    private final OutputStream out;
    private final OutputStream stackTraceOut;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void forward(InputStream in, OutputStream out) throws IOException {
        try {
            int length;
            byte[] buf = new byte[4096];
            while ((length = in.read(buf)) != -1) {
                if (out == null) continue;
                out.write(buf, 0, length);
                if (in.available() != 0) continue;
                out.flush();
            }
        }
        finally {
            in.close();
            out.close();
        }
    }

    public StreamForwarder(InputStream in, OutputStream out, OutputStream stackTraceOut) {
        this.in = in;
        this.out = out;
        this.stackTraceOut = stackTraceOut;
    }

    public void run() {
        try {
            StreamForwarder.forward(this.in, this.out);
        }
        catch (Throwable ex) {
            if (this.stackTraceOut == null) {
                throw new RuntimeException(ex);
            }
            ex.printStackTrace(new PrintStream(this.stackTraceOut));
        }
    }
}

