/*
 * Decompiled with CFR 0.152.
 */
package com.aspect.snoop.agent;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class AgentLogger {
    public static final int TRACE = 0;
    public static final int DEBUG = 1;
    public static final int INFO = 2;
    public static final int WARN = 3;
    public static final int ERROR = 4;
    public static final int FATAL = 5;
    public static final int OFF = 6;
    private static final Map<Integer, String> levelMap = new HashMap<Integer, String>();
    private static final Map<String, Integer> nameMap = new HashMap<String, Integer>();
    private static String logFile = System.getProperty("user.home") + "/snoop.log";
    private static final String prefix = "[JSNOOP ";
    private static final String suffix = "] ";
    private static final String nl = System.getProperty("line.separator");
    public static int level;

    public static String levelName(int l) {
        return levelMap.get(l);
    }

    public static Integer levelValue(String s) {
        return nameMap.get(s);
    }

    public static void trace(String s) {
        if (level <= 0) {
            AgentLogger._log(AgentLogger.getPrefix() + s);
        }
    }

    public static void debug(String s, Throwable t) {
        if (level <= 1) {
            AgentLogger._log(AgentLogger.getPrefix() + s);
            AgentLogger._log(t);
        }
    }

    public static void debug(String s) {
        if (level <= 1) {
            AgentLogger._log(AgentLogger.getPrefix() + s);
        }
    }

    public static void info(String s) {
        if (level <= 2) {
            AgentLogger._log(AgentLogger.getPrefix() + s);
        }
    }

    public static void warn(String s) {
        if (level <= 3) {
            AgentLogger._log(AgentLogger.getPrefix() + s);
        }
    }

    public static void warn(String s, Throwable t) {
        if (level <= 3) {
            AgentLogger._log(AgentLogger.getPrefix() + s);
            AgentLogger._log(t);
        }
    }

    public static void error(Throwable t) {
        if (level <= 4) {
            AgentLogger._log(AgentLogger.getPrefix() + t.getMessage());
            AgentLogger._log(t);
        }
    }

    public static void error(String s) {
        if (level <= 4) {
            AgentLogger._log(AgentLogger.getPrefix() + s);
        }
    }

    public static void error(String s, Throwable t) {
        if (level <= 4) {
            AgentLogger._log(AgentLogger.getPrefix() + s);
            AgentLogger._log(t);
        }
    }

    public static void fatal(String s) {
        if (level <= 5) {
            AgentLogger._log(AgentLogger.getPrefix() + s);
        }
    }

    public static void fatal(Throwable t) {
        if (level <= 5) {
            AgentLogger._log(AgentLogger.getPrefix() + t.getMessage());
            AgentLogger._log(t);
        }
    }

    public static void fatal(String s, Throwable t) {
        if (level <= 5) {
            AgentLogger._log(AgentLogger.getPrefix() + s);
            AgentLogger._log(t);
        }
    }

    private static String getPrefix() {
        return prefix + AgentLogger.getTime() + " " + AgentLogger.levelName(level) + suffix;
    }

    private static String getTime() {
        return new SimpleDateFormat().format(new Date());
    }

    private static void _log(String s) {
        try {
            FileOutputStream fos = new FileOutputStream(logFile, true);
            fos.write(s.getBytes());
            fos.write(nl.getBytes());
            fos.close();
        }
        catch (IOException e) {
            AgentLogger._log(s);
        }
    }

    private static void _log(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        pw.flush();
        AgentLogger._log(sw.toString());
    }

    static {
        levelMap.put(0, "TRACE");
        levelMap.put(1, "DEBUG");
        levelMap.put(2, "INFO");
        levelMap.put(3, "WARN");
        levelMap.put(4, "ERROR");
        levelMap.put(5, "FATAL");
        levelMap.put(6, "OFF");
        nameMap.put("TRACE", 0);
        nameMap.put("DEBUG", 1);
        nameMap.put("INFO", 2);
        nameMap.put("WARN", 3);
        nameMap.put("ERROR", 4);
        nameMap.put("FATAL", 5);
        nameMap.put("OFF", 6);
        level = 1;
    }
}

