/*
 * Decompiled with CFR 0.152.
 */
package com.aspect.snoop.ui;

import com.aspect.org.jdesktop.application.Action;
import com.aspect.org.jdesktop.application.Application;
import com.aspect.org.jdesktop.application.ApplicationActionMap;
import com.aspect.org.jdesktop.application.ResourceMap;
import com.aspect.snoop.JavaSnoop;
import com.aspect.snoop.agent.AgentJarCreator;
import com.aspect.snoop.agent.AgentLogger;
import com.aspect.snoop.agent.SnoopAgent;
import com.aspect.snoop.agent.manager.InstrumentationManager;
import com.aspect.snoop.util.IOUtil;
import com.aspect.snoop.util.JadUtil;
import com.aspect.snoop.util.UIUtil;
import java.awt.Frame;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.LayoutStyle;
import javax.swing.SwingWorker;

public class DumpSourceCodeView
extends JDialog {
    final File dir;
    List<URL> urls;
    SwingWorker dump;
    private JButton btnCancelDump;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel lblJar;
    private JProgressBar prgBarClassCountInJar;
    private JProgressBar prgBarJarCount;

    public DumpSourceCodeView(Frame parent, boolean modal, InstrumentationManager mgr, File dir) {
        super(parent, modal);
        this.initComponents();
        this.dir = dir;
        this.urls = new ArrayList<URL>();
        for (URL u : mgr.getCodeSourceURLs()) {
            boolean matched = false;
            for (String snoopLib : AgentJarCreator.jarsToNotBootClasspath) {
                if (!u.getFile().endsWith(snoopLib)) continue;
                matched = true;
            }
            if (matched) continue;
            this.urls.add(u);
        }
        this.prgBarJarCount.setMinimum(0);
        this.prgBarJarCount.setMaximum(this.urls.size());
        this.prgBarJarCount.setValue(0);
        this.prgBarClassCountInJar.setMinimum(0);
        this.prgBarClassCountInJar.setMaximum(0);
        this.prgBarClassCountInJar.setValue(0);
    }

    public void startDump() {
        final DumpSourceCodeView parent = this;
        this.dump = new SwingWorker(){

            protected Object doInBackground() throws Exception {
                DumpSourceCodeView.this.prgBarJarCount.setStringPainted(true);
                int urlCount = DumpSourceCodeView.this.urls.size();
                for (int i = 0; i < urlCount && !this.isCancelled(); ++i) {
                    DumpSourceCodeView.this.prgBarJarCount.setString(i + 1 + " / " + urlCount);
                    DumpSourceCodeView.this.prgBarJarCount.setValue(i + 1);
                    parent.repaint();
                    URL u = DumpSourceCodeView.this.urls.get(i);
                    AgentLogger.debug("Dumping source for: " + u.toString());
                    if (u.getFile().endsWith("JavaSnoop.jar")) {
                        AgentLogger.trace("Skipping JavaSnoop JAR");
                        continue;
                    }
                    DumpSourceCodeView.this.lblJar.setText(u.toExternalForm());
                    parent.repaint();
                    File f = null;
                    try {
                        f = new File(u.toURI());
                    }
                    catch (URISyntaxException e) {
                        UIUtil.showErrorMessage(SnoopAgent.getMainView(), "Error looking up jar" + u.toExternalForm());
                        AgentLogger.error("Error looking up jar", e);
                        continue;
                    }
                    if (!f.exists() || !f.isFile() || !u.getFile().endsWith(".jar")) continue;
                    JarFile jar = null;
                    try {
                        jar = new JarFile(f);
                    }
                    catch (IOException e) {
                        UIUtil.showErrorMessage(SnoopAgent.getMainView(), "Error reading jar for dumping source: " + u.toExternalForm());
                        AgentLogger.error("Error reading jar for dumping souce", e);
                    }
                    Enumeration<JarEntry> entries = jar.entries();
                    DumpSourceCodeView.this.prgBarClassCountInJar.setIndeterminate(true);
                    parent.repaint();
                    while (entries.hasMoreElements() && !this.isCancelled()) {
                        JarEntry entry = entries.nextElement();
                        File targetFile = new File(DumpSourceCodeView.this.dir, entry.getName().replaceAll("\\.class", ".java"));
                        DumpSourceCodeView.this.prgBarClassCountInJar.setStringPainted(true);
                        DumpSourceCodeView.this.prgBarClassCountInJar.setString(entry.getName());
                        parent.repaint();
                        if (entry.isDirectory()) {
                            targetFile.mkdirs();
                            continue;
                        }
                        targetFile.getParentFile().mkdirs();
                        try {
                            InputStream is = jar.getInputStream(entry);
                            byte[] bytes = IOUtil.getBytesFromStream(is);
                            FileOutputStream fos = new FileOutputStream(targetFile);
                            if (entry.getName().endsWith(".class")) {
                                String clsName = entry.getName().replaceAll("/", "\\.");
                                clsName = clsName.substring(0, clsName.length() - 6);
                                String s = JadUtil.getDecompiledJava(clsName, bytes);
                                fos.write(s.getBytes());
                            } else {
                                fos.write(bytes);
                            }
                            fos.close();
                        }
                        catch (IOException ioe) {
                            AgentLogger.debug("Error with dump source", ioe);
                        }
                    }
                    DumpSourceCodeView.this.prgBarClassCountInJar.setIndeterminate(false);
                    parent.repaint();
                }
                return null;
            }
        };
        this.dump.execute();
    }

    private void initComponents() {
        this.prgBarJarCount = new JProgressBar();
        this.prgBarClassCountInJar = new JProgressBar();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.btnCancelDump = new JButton();
        this.lblJar = new JLabel();
        this.setDefaultCloseOperation(2);
        ResourceMap resourceMap = ((JavaSnoop)Application.getInstance(JavaSnoop.class)).getContext().getResourceMap(DumpSourceCodeView.class);
        this.setTitle(resourceMap.getString("Form.title", new Object[0]));
        this.setName("Form");
        this.prgBarJarCount.setName("prgBarJarCount");
        this.prgBarClassCountInJar.setName("prgBarClassCountInJar");
        this.jLabel1.setText(resourceMap.getString("jLabel1.text", new Object[0]));
        this.jLabel1.setName("jLabel1");
        this.jLabel2.setText(resourceMap.getString("jLabel2.text", new Object[0]));
        this.jLabel2.setName("jLabel2");
        ApplicationActionMap actionMap = ((JavaSnoop)Application.getInstance(JavaSnoop.class)).getContext().getActionMap(DumpSourceCodeView.class, (Object)this);
        this.btnCancelDump.setAction(actionMap.get("cancelDump"));
        this.btnCancelDump.setText(resourceMap.getString("btnCancelDump.text", new Object[0]));
        this.btnCancelDump.setName("btnCancelDump");
        this.lblJar.setText(resourceMap.getString("lblJar.text", new Object[0]));
        this.lblJar.setName("lblJar");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.prgBarClassCountInJar, GroupLayout.Alignment.LEADING, -1, 427, Short.MAX_VALUE).addComponent(this.prgBarJarCount, GroupLayout.Alignment.LEADING, -1, 427, Short.MAX_VALUE).addComponent(this.btnCancelDump).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.jLabel1).addGap(18, 18, 18).addComponent(this.lblJar, -1, 290, Short.MAX_VALUE)).addComponent(this.jLabel2, GroupLayout.Alignment.LEADING)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.lblJar)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.prgBarClassCountInJar, -2, 26, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.prgBarJarCount, -2, 26, -2).addGap(18, 18, 18).addComponent(this.btnCancelDump).addContainerGap()));
        layout.linkSize(1, this.prgBarClassCountInJar, this.prgBarJarCount);
        this.pack();
    }

    @Action
    public void cancelDump() {
        this.dump.cancel(true);
        this.dispose();
    }
}

