/*
 * Decompiled with CFR 0.152.
 */
package com.aspect.snoop;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class MethodWrapper {
    AccessibleObject method;
    boolean constructor;
    String name;

    public static MethodWrapper getWrapper(Class clazz, String methodName, Class[] parameterTypes) {
        try {
            if ("<init>".equals(methodName)) {
                return MethodWrapper.getWrapper(clazz.getDeclaredConstructor(parameterTypes));
            }
            return MethodWrapper.getWrapper(clazz.getDeclaredMethod(methodName, parameterTypes));
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static MethodWrapper getWrapper(Member obj) {
        if (obj instanceof Method) {
            return new MethodWrapper((Method)obj);
        }
        if (obj instanceof Constructor) {
            return new MethodWrapper((Constructor)obj);
        }
        throw new IllegalArgumentException("Expecting method or constructor");
    }

    public static MethodWrapper getWrapper(AccessibleObject obj) {
        if (obj instanceof Method) {
            return new MethodWrapper((Method)obj);
        }
        if (obj instanceof Constructor) {
            return new MethodWrapper((Constructor)obj);
        }
        throw new IllegalArgumentException("Expecting method or constructor");
    }

    public MethodWrapper(Method m) {
        this.method = m;
        this.constructor = false;
        this.name = m.getName();
    }

    public MethodWrapper(Constructor c) {
        this.method = c;
        this.constructor = true;
        this.name = "<init>";
    }

    public String getName() {
        return this.name;
    }

    public Class getDeclaringClass() {
        if (this.constructor) {
            return ((Constructor)this.method).getDeclaringClass();
        }
        return ((Method)this.method).getDeclaringClass();
    }

    public Class[] getParameterTypes() {
        if (this.constructor) {
            return ((Constructor)this.method).getParameterTypes();
        }
        return ((Method)this.method).getParameterTypes();
    }

    public Class getReturnType() {
        if (this.constructor) {
            return Void.class;
        }
        return ((Method)this.method).getReturnType();
    }

    public boolean isAbstract() {
        if (this.constructor) {
            return Modifier.isAbstract(((Constructor)this.method).getModifiers());
        }
        return Modifier.isAbstract(((Method)this.method).getModifiers());
    }

    public boolean isConstructor() {
        return this.constructor;
    }

    public int getModifiers() {
        if (this.constructor) {
            return ((Constructor)this.method).getModifiers();
        }
        return ((Method)this.method).getModifiers();
    }

    public String getDescription() {
        return this.method.toString();
    }

    public AccessibleObject getActualMethod() {
        return this.method;
    }
}

