/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.view.swing.tree.model;

import com.jsql.model.bean.database.AbstractElementDatabase;
import com.jsql.model.suspendable.AbstractSuspendable;
import com.jsql.util.I18nUtil;
import com.jsql.util.LogLevelUtil;
import com.jsql.util.StringUtil;
import com.jsql.view.swing.tree.ImageOverlap;
import com.jsql.view.swing.tree.PanelNode;
import com.jsql.view.swing.tree.action.ActionLoadStop;
import com.jsql.view.swing.tree.action.ActionPauseUnpause;
import com.jsql.view.swing.tree.custom.JPopupMenuCustomExtract;
import com.jsql.view.swing.tree.model.NodeModelDatabase;
import com.jsql.view.swing.tree.model.NodeModelTable;
import com.jsql.view.swing.util.I18nViewUtil;
import com.jsql.view.swing.util.MediatorHelper;
import com.jsql.view.swing.util.UiStringUtil;
import com.jsql.view.swing.util.UiUtil;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.border.LineBorder;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractNodeModel {
    private static final Logger LOGGER = LogManager.getRootLogger();
    private static final String TREE_BACKGROUND = "Tree.background";
    private AbstractElementDatabase elementDatabase;
    private String textEmptyNode;
    private int indexProgress = 0;
    private boolean isSelected = false;
    private boolean isRunning = false;
    private boolean isAnyCheckboxSelected = false;
    private boolean isLoaded = false;
    private boolean isProgressing = false;
    private boolean isLoading = false;
    private PanelNode panelNode;
    private boolean isEdited;

    protected AbstractNodeModel(AbstractElementDatabase elementDatabase) {
        this.elementDatabase = elementDatabase;
    }

    protected AbstractNodeModel(String emptyObject) {
        this.textEmptyNode = emptyObject;
    }

    protected abstract void buildMenu(JPopupMenuCustomExtract var1, TreePath var2);

    public abstract boolean isPopupDisplayable();

    protected abstract Icon getLeafIcon(boolean var1);

    public abstract void runAction();

    public void showPopup(DefaultMutableTreeNode currentTableNode, TreePath path, MouseEvent e) {
        JPopupMenuCustomExtract popupMenu = new JPopupMenuCustomExtract();
        AbstractSuspendable suspendableTask = MediatorHelper.model().getMediatorUtils().getThreadUtil().get(this.elementDatabase);
        this.initItemLoadPause(currentTableNode, popupMenu, suspendableTask);
        this.initItemRenameReload(currentTableNode, path, popupMenu);
        this.buildMenu(popupMenu, path);
        this.displayPopupMenu(e, popupMenu);
    }

    private void displayPopupMenu(MouseEvent e, JPopupMenuCustomExtract popupMenu) {
        popupMenu.applyComponentOrientation(ComponentOrientation.getOrientation(I18nUtil.getCurrentLocale()));
        popupMenu.show(MediatorHelper.treeDatabase(), ComponentOrientation.RIGHT_TO_LEFT.equals(ComponentOrientation.getOrientation(I18nUtil.getCurrentLocale())) ? e.getX() - popupMenu.getWidth() : e.getX(), e.getY());
        popupMenu.setLocation(ComponentOrientation.RIGHT_TO_LEFT.equals(ComponentOrientation.getOrientation(I18nUtil.getCurrentLocale())) ? e.getXOnScreen() - popupMenu.getWidth() : e.getXOnScreen(), e.getYOnScreen());
    }

    private void initItemRenameReload(DefaultMutableTreeNode currentTableNode, TreePath path, JPopupMenuCustomExtract popupMenu) {
        String textReload = this instanceof NodeModelDatabase ? I18nViewUtil.valueByKey("RELOAD_TABLES") : (this instanceof NodeModelTable ? I18nViewUtil.valueByKey("RELOAD_COLUMNS") : "?");
        JMenuItem menuItemReload = new JMenuItem(textReload);
        menuItemReload.setEnabled(!this.isRunning);
        menuItemReload.addActionListener(actionEvent -> this.runAction());
        JMenuItem menuItemRename = new JMenuItem(I18nViewUtil.valueByKey("RENAME_NODE"));
        menuItemRename.setEnabled(!this.isRunning);
        menuItemRename.addActionListener(actionEvent -> {
            AbstractNodeModel nodeModel = (AbstractNodeModel)currentTableNode.getUserObject();
            nodeModel.setIsEdited(true);
            this.getPanel().getNodeLabel().setVisible(false);
            this.getPanel().getTextFieldEditable().setVisible(true);
            MediatorHelper.treeDatabase().setSelectionPath(path);
        });
        popupMenu.add(new JSeparator());
        popupMenu.add(menuItemRename);
        popupMenu.add(menuItemReload);
    }

    private void initItemLoadPause(DefaultMutableTreeNode currentTableNode, JPopupMenuCustomExtract popupMenu, AbstractSuspendable suspendableTask) {
        JMenuItem menuItemLoad = new JMenuItem(this.isRunning ? I18nViewUtil.valueByKey("THREAD_STOP") : I18nViewUtil.valueByKey("THREAD_LOAD"), 111);
        if (!this.isAnyCheckboxSelected && !this.isRunning) {
            menuItemLoad.setEnabled(false);
        }
        menuItemLoad.addActionListener(new ActionLoadStop(this, currentTableNode));
        JMenuItem menuItemPause = new JMenuItem(suspendableTask != null && suspendableTask.isPaused() ? I18nViewUtil.valueByKey("THREAD_RESUME") : I18nViewUtil.valueByKey("THREAD_PAUSE"), 115);
        if (!this.isRunning) {
            menuItemPause.setEnabled(false);
        }
        menuItemPause.addActionListener(new ActionPauseUnpause(this));
        popupMenu.add(menuItemLoad);
        popupMenu.add(menuItemPause);
    }

    public Component getComponent(JTree tree, Object nodeRenderer, boolean isSelected, boolean isLeaf, boolean hasFocus) {
        DefaultMutableTreeNode currentNode = (DefaultMutableTreeNode)nodeRenderer;
        this.panelNode = new PanelNode(tree, currentNode);
        if (isSelected) {
            this.panelNode.setBackground(hasFocus ? UIManager.getColor("Tree.selectionBackground") : UIManager.getColor("Tree.selectionInactiveBackground"));
        } else {
            this.panelNode.setBackground(UIManager.getColor(TREE_BACKGROUND));
        }
        this.initIcon(isLeaf);
        AbstractNodeModel nodeModel = (AbstractNodeModel)currentNode.getUserObject();
        this.initEditable(nodeModel.isEdited);
        this.initLabel(isSelected, hasFocus, nodeModel.isEdited);
        this.initProgress(currentNode);
        return this.panelNode;
    }

    private void initIcon(boolean isLeaf) {
        this.panelNode.showIcon();
        this.panelNode.setIconNode(this.getLeafIcon(isLeaf));
    }

    private void initProgress(DefaultMutableTreeNode currentNode) {
        if (this.isLoading) {
            this.displayProgress(this.panelNode, currentNode);
            this.panelNode.hideIcon();
        } else if (this.isProgressing) {
            this.panelNode.showLoader();
            this.panelNode.hideIcon();
            AbstractSuspendable suspendableTask = MediatorHelper.model().getMediatorUtils().getThreadUtil().get(this.elementDatabase);
            if (suspendableTask != null && suspendableTask.isPaused()) {
                this.panelNode.setLoaderIcon(new ImageOverlap(UiUtil.HOURGLASS.getIcon(), "swing/images/icons/pause.png"));
            }
        }
    }

    private void initLabel(boolean isSelected, boolean hasFocus, boolean isEdited) {
        JLabel nodeLabel = this.panelNode.getNodeLabel();
        try {
            nodeLabel.setText(UiStringUtil.detectUtf8Html(this.toString()));
        }
        catch (NullPointerException e) {
            LOGGER.log(LogLevelUtil.CONSOLE_JAVA, e, (Throwable)e);
        }
        nodeLabel.setVisible(!isEdited);
        if (isSelected) {
            if (hasFocus) {
                nodeLabel.setForeground(UIManager.getColor("Tree.selectionForeground"));
                nodeLabel.setBackground(UIManager.getColor("Tree.selectionBackground"));
            } else {
                nodeLabel.setForeground(UIManager.getColor("Tree.selectionInactiveForeground"));
                nodeLabel.setBackground(UIManager.getColor("Tree.selectionInactiveBackground"));
            }
            nodeLabel.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        } else if (hasFocus) {
            nodeLabel.setBackground(UIManager.getColor("Tree.foreground"));
            nodeLabel.setBackground(UIManager.getColor(TREE_BACKGROUND));
            nodeLabel.setBorder(new LineBorder(UIManager.getColor("Tree.selectionBorderColor"), 1, false));
        } else {
            nodeLabel.setBackground(UIManager.getColor("Tree.foreground"));
            nodeLabel.setBackground(UIManager.getColor(TREE_BACKGROUND));
            nodeLabel.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        }
    }

    private void initEditable(boolean isEdited) {
        if (StringUtil.isUtf8(this.getElementDatabase().toString())) {
            this.panelNode.getTextFieldEditable().setFont(UiUtil.FONT_MONO_ASIAN);
        } else {
            this.panelNode.getTextFieldEditable().setFont(UiUtil.FONT_NON_MONO);
        }
        this.panelNode.getTextFieldEditable().setText(StringUtil.detectUtf8(this.getElementDatabase().toString()));
        this.panelNode.getTextFieldEditable().setVisible(isEdited);
    }

    protected void displayProgress(PanelNode panelNode, DefaultMutableTreeNode currentNode) {
        int dataCount = this.elementDatabase.getChildCount();
        panelNode.getProgressBar().setMaximum(dataCount);
        panelNode.getProgressBar().setValue(this.indexProgress);
        panelNode.getProgressBar().setVisible(true);
        AbstractSuspendable suspendableTask = MediatorHelper.model().getMediatorUtils().getThreadUtil().get(this.elementDatabase);
        if (suspendableTask != null && suspendableTask.isPaused()) {
            panelNode.getProgressBar().pause();
        }
    }

    public String toString() {
        return this.elementDatabase != null ? this.elementDatabase.getLabelWithCount() : this.textEmptyNode;
    }

    protected AbstractElementDatabase getParent() {
        return this.elementDatabase.getParent();
    }

    public AbstractElementDatabase getElementDatabase() {
        return this.elementDatabase;
    }

    public void setIndexProgress(int indexProgress) {
        this.indexProgress = indexProgress;
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    public void setSelected(boolean isSelected) {
        this.isSelected = isSelected;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public void setRunning(boolean isRunning) {
        this.isRunning = isRunning;
    }

    public void setIsAnyCheckboxSelected(boolean isAnyCheckboxSelected) {
        this.isAnyCheckboxSelected = isAnyCheckboxSelected;
    }

    public boolean isLoaded() {
        return this.isLoaded;
    }

    public void setLoaded(boolean isLoaded) {
        this.isLoaded = isLoaded;
    }

    public void setProgressing(boolean isProgressing) {
        this.isProgressing = isProgressing;
    }

    public void setLoading(boolean isLoading) {
        this.isLoading = isLoading;
    }

    public PanelNode getPanel() {
        return this.panelNode;
    }

    public void setIsEdited(boolean isEdited) {
        this.isEdited = isEdited;
    }

    public void setText(String textI18n) {
        this.textEmptyNode = textI18n;
    }
}

