# Security Policy

OWASP Juice Shop is an _intentionally vulnerable_ web application, but we still do not want to be suprised by zero day
vulnerabilities which are not part of our hacking challenges. We are following the proposed Internet
standard <https://securitytxt.org> so you can find our
"security" policy in any running instance of the application at the expected location described in
<https://tools.ietf.org/html/draft-foudil-securitytxt-06>. Finding it is actually one of our hacking challenges!

## Supported Versions

We provide security patches for the latest released minor version.

| Version | Supported          |
|:--------|:-------------------|
| 16.0.x  | :white_check_mark: |
| <16.0   | :x:                |

## Reporting a Vulnerability

For vulnerabilities which are **not** part of any hacking challenge please contact <bjoern.kimminich@owasp.org>. In all
other cases please contact our shop's "security team" at the address mentioned in the
`security.txt` accessible through the running application.

> Instead of fixing reported vulnerabilities we might turn them into
> hacking challenges! You might receive a reward for reporting a
> vulnerability that makes it into one of our challenges!

### Encrypted communication

You can encrypt emails to <bjoern.kimminich@owasp.org> with PGP using the public key `062A85A8CBFBDCDA`:

```
-----BEGIN PGP PUBLIC KEY BLOCK-----
Version: GnuPG v2
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=z48d
-----END PGP PUBLIC KEY BLOCK-----
```
