# Contributing

Are you interested in contributing to Legion? We love contributors! We ask that you follow the guidelines below when
making contributions to the project. We ask that you also follow our contributor [**Code of Conduct**](#code-of-conduct)
. We look forward to working with you - get started in one of the sections below.

#### Did you find a bug?

* Awesome. First, ensure that your bug isn't a duplicate by checking
  the [Issues](https://github.com/Hackman238/legion/issues). **If the issue already exists**, go ahead and comment on
  the issue with your bug report information, following the guidelines below as if you were reporting a new issue - just
  don't make a new issue.
* **If you can't find the issue**, its time to [open a new issue](https://github.com/Hackman238/legion/issues/new). Fill
  in the issue with a clear title and description. Where possible, include steps to reproduce the bug, code samples, and
  screenshots. Tag the issue if it fits into one of our existing categories.

#### Did you patch a bug?

* Excellent - your first steps are to open a new [Pull Request](https://github.com/Hackman238/legion/pulls) with your
  patch. Be prepared to answer questions or receive feedback from the team.
* Ensure the PR has a description that clearly details the problem and your solution. Be sure to include issue numbers
  if possible.
* Follow our coding practices and standards for whatever files you're working on.

#### Do you want to add a feature?

* We love new features! Please [make an issue](https://github.com/Hackman238/legion/issues/new) for discussion, with a
  clear title and description of the proposed feature. Add the Proposal tag, and use the comments to follow up with the
  team.
* Wait for a response and approval to your proposal before working on your patch and submitting a PR. This way, if we
  find any problems with the proposal, and discuss remediation before work gets wasted.
* Once your feature is complete, all you need to do is [submit a PR](https://github.com/Hackman238/legion/pulls).

#### Do you have a general question?

* If you have any questions not related to legion's code, features, or bugs use legion@shanewilliamscott.com

#### Code of Conduct

We like to keep the rules simple.

* Behavior meant to malign, disrespect, denigrate, harass, or attack any person will not be tolerated.
* Use respectful language and foster a community of collaboration.

