# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class AccountProvisioningMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The service account provisioning mode for this Active Directory connector."""

    AUTOMATIC = "automatic"
    MANUAL = "manual"


class ArcSqlManagedInstanceLicenseType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The license type to apply for this managed instance."""

    BASE_PRICE = "BasePrice"
    LICENSE_INCLUDED = "LicenseIncluded"
    DISASTER_RECOVERY = "DisasterRecovery"


class ArcSqlServerLicenseType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """SQL Server license type."""

    UNDEFINED = "Undefined"
    FREE = "Free"
    HADR = "HADR"
    SERVER_CAL = "ServerCAL"
    LICENSE_ONLY = "LicenseOnly"
    PAYG = "PAYG"
    PAID = "Paid"


class ConnectionStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The cloud connectivity status."""

    CONNECTED = "Connected"
    DISCONNECTED = "Disconnected"
    REGISTERED = "Registered"
    UNKNOWN = "Unknown"


class CreatedByType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of identity that created the resource."""

    USER = "User"
    APPLICATION = "Application"
    MANAGED_IDENTITY = "ManagedIdentity"
    KEY = "Key"


class DefenderStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Status of Azure Defender."""

    PROTECTED = "Protected"
    UNPROTECTED = "Unprotected"
    UNKNOWN = "Unknown"


class EditionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """SQL Server edition."""

    EVALUATION = "Evaluation"
    ENTERPRISE = "Enterprise"
    STANDARD = "Standard"
    WEB = "Web"
    DEVELOPER = "Developer"
    EXPRESS = "Express"


class ExtendedLocationTypes(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of extendedLocation."""

    CUSTOM_LOCATION = "CustomLocation"


class HostType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of host for Azure Arc SQL Server."""

    AZURE_VIRTUAL_MACHINE = "Azure Virtual Machine"
    AZURE_VM_WARE_VIRTUAL_MACHINE = "Azure VMWare Virtual Machine"
    AZURE_KUBERNETES_SERVICE = "Azure Kubernetes Service"
    AWS_VM_WARE_VIRTUAL_MACHINE = "AWS VMWare Virtual Machine"
    AWS_KUBERNETES_SERVICE = "AWS Kubernetes Service"
    GCP_VM_WARE_VIRTUAL_MACHINE = "GCP VMWare Virtual Machine"
    GCP_KUBERNETES_SERVICE = "GCP Kubernetes Service"
    CONTAINER = "Container"
    VIRTUAL_MACHINE = "Virtual Machine"
    PHYSICAL_SERVER = "Physical Server"
    AWS_VIRTUAL_MACHINE = "AWS Virtual Machine"
    GCP_VIRTUAL_MACHINE = "GCP Virtual Machine"
    OTHER = "Other"


class Infrastructure(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The infrastructure the data controller is running on."""

    AZURE = "azure"
    GCP = "gcp"
    AWS = "aws"
    ALIBABA = "alibaba"
    ONPREMISES = "onpremises"
    OTHER = "other"


class OperationOrigin(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The intended executor of the operation."""

    USER = "user"
    SYSTEM = "system"


class SqlManagedInstanceSkuTier(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The pricing tier for the instance."""

    GENERAL_PURPOSE = "GeneralPurpose"
    BUSINESS_CRITICAL = "BusinessCritical"


class SqlVersion(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """SQL Server version."""

    SQL_SERVER2012 = "SQL Server 2012"
    SQL_SERVER2014 = "SQL Server 2014"
    SQL_SERVER2016 = "SQL Server 2016"
    SQL_SERVER2017 = "SQL Server 2017"
    SQL_SERVER2019 = "SQL Server 2019"
    SQL_SERVER2022 = "SQL Server 2022"
    UNKNOWN = "Unknown"
