# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.identity import DefaultAzureCredential

from azure.mgmt.connectedcache import ConnectedCacheMgmtClient

"""
# PREREQUISITES
    pip install azure-identity
    pip install azure-mgmt-connectedcache
# USAGE
    python enterprise_mcc_customers_create_or_update_maximum_set_gen.py

    Before run the sample, please set the values of the client ID, tenant ID and client secret
    of the AAD application as environment variables: AZURE_CLIENT_ID, AZURE_TENANT_ID,
    AZURE_CLIENT_SECRET. For more info about how to get the value, please see:
    https://docs.microsoft.com/azure/active-directory/develop/howto-create-service-principal-portal
"""


def main():
    client = ConnectedCacheMgmtClient(
        credential=DefaultAzureCredential(),
        subscription_id="SUBSCRIPTION_ID",
    )

    response = client.enterprise_mcc_customers.begin_create_or_update(
        resource_group_name="rgConnectedCache",
        customer_resource_name="MccRPTest1",
        resource={
            "location": "westus",
            "properties": {
                "additionalCustomerProperties": {
                    "customerAsn": "hgrelgnrtdkleisnepfolu",
                    "customerEmail": "zdjgibsidydyzm",
                    "customerEntitlementExpiration": "2024-01-30T00:54:04.773Z",
                    "customerEntitlementSkuGuid": "rvzmdpxyflgqetvpwupnfaxsweiiz",
                    "customerEntitlementSkuId": "b",
                    "customerEntitlementSkuName": "waaqfijr",
                    "customerTransitAsn": "habgklnxqzmozqpazoyejwiphezpi",
                    "customerTransitState": "voblixkxfejbmhxilb",
                    "optionalProperty1": "qhmwxza",
                    "optionalProperty2": "l",
                    "optionalProperty3": "mblwwvbie",
                    "optionalProperty4": "vzuek",
                    "optionalProperty5": "fzjodscdfcdr",
                },
                "customer": {
                    "clientTenantId": "fproidkpgvpdnac",
                    "contactEmail": "xquos",
                    "contactName": "wxyqjoyoscmvimgwhpitxky",
                    "contactPhone": "vue",
                    "customerName": "mkpzynfqihnjfdbaqbqwyhd",
                    "fullyQualifiedResourceId": "uqsbtgae",
                    "isEnterpriseManaged": True,
                    "isEntitled": True,
                    "releaseVersion": 20,
                    "resendSignupCode": True,
                    "shouldMigrate": True,
                    "verifySignupCode": True,
                    "verifySignupPhrase": "tprjvttkgmrqlsyicnidhm",
                },
                "error": {},
            },
            "tags": {"key3379": "dpyqeaqhcnutzezom"},
        },
    ).result()
    print(response)


# x-ms-original-file: 2023-05-01-preview/EnterpriseMccCustomers_CreateOrUpdate_MaximumSet_Gen.json
if __name__ == "__main__":
    main()
