% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nav-items.R
\name{nav-items}
\alias{nav-items}
\alias{nav_panel}
\alias{nav_panel_hidden}
\alias{nav_menu}
\alias{nav_item}
\alias{nav_spacer}
\title{Navigation items}
\usage{
nav_panel(title, ..., value = title, icon = NULL)

nav_panel_hidden(value, ..., icon = NULL)

nav_menu(title, ..., value = title, icon = NULL, align = c("left", "right"))

nav_item(...)

nav_spacer()
}
\arguments{
\item{title}{A title to display. Can be a character string or UI elements
(i.e., \link[htmltools:builder]{htmltools::tags}).}

\item{...}{Depends on the function:
\itemize{
\item For \code{nav_panel()} and \code{nav_panel_hidden()}: UI elements (i.e.,
\link[htmltools:builder]{htmltools::tags}) to display when the item is active.
\item For \code{nav_menu()}: a collection of nav items (e.g., \code{nav_panel()},
\code{nav_item()}).
\item For \code{nav_item()}: UI elements (i.e., \link[htmltools:builder]{htmltools::tags}) to place directly in
the navigation panel (e.g., search forms, links to external content, etc).
}}

\item{value}{A character string to assign to the nav item. This value may be
supplied to the relevant container's \code{selected} argument in order to show
particular nav item's content immediately on page load. This value is also
useful for programmatically updating the selected content via
\code{\link[=nav_select]{nav_select()}}, \code{\link[=nav_hide]{nav_hide()}}, etc (updating selected tabs this way is often
useful for showing/hiding panels of content via other UI controls like
\code{\link[shiny:radioButtons]{shiny::radioButtons()}} -- in this scenario, consider using
\code{\link[=nav_panel_hidden]{nav_panel_hidden()}} with \code{\link[=navset_hidden]{navset_hidden()}}).}

\item{icon}{Optional icon to appear next to the nav item's \code{title}.}

\item{align}{horizontal alignment of the dropdown menu relative to dropdown toggle.}
}
\value{
A nav item that may be passed to a nav container (e.g. \code{\link[=navset_tab]{navset_tab()}}).
}
\description{
Create nav item(s) for use inside nav containers (e.g., \code{\link[=navset_tab]{navset_tab()}},
\code{\link[=navset_bar]{navset_bar()}}, etc).
}
\section{Functions}{
\itemize{
\item \code{nav_panel()}: Content to display when the given item is selected.

\item \code{nav_panel_hidden()}: Create nav content for use inside \code{navset_hidden()} (for
creating custom navigation controls via \code{navs_select()}),

\item \code{nav_menu()}: Create a menu of nav items.

\item \code{nav_item()}: Place arbitrary content in the navigation panel (e.g., search
forms, links to external content, etc.)

\item \code{nav_spacer()}: Adding spacing between nav items.

}}
\seealso{
\link{navset} create the navigation container holding the nav panels.

\code{\link[=nav_menu]{nav_menu()}}, \code{\link[=nav_item]{nav_item()}}, \code{\link[=nav_spacer]{nav_spacer()}} create menus, items, or
space in the navset control area.

\code{\link[=nav_insert]{nav_insert()}}, \code{\link[=nav_remove]{nav_remove()}} programmatically add or remove nav
panels.

\code{\link[=nav_select]{nav_select()}}, \code{\link[=nav_show]{nav_show()}}, \code{\link[=nav_hide]{nav_hide()}} change the state of a
\code{\link[=nav_panel]{nav_panel()}} in a navset.

Other Panel container functions: 
\code{\link{nav_select}()},
\code{\link{navset}}
}
\concept{Panel container functions}
