% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/function_return_linter.R
\name{function_return_linter}
\alias{function_return_linter}
\title{Lint common mistakes/style issues cropping up from return statements}
\usage{
function_return_linter()
}
\description{
\code{return(x <- ...)} is either distracting (because \code{x} is ignored), or
confusing (because assigning to \code{x} has some side effect that is muddled
by the dual-purpose expression).
}
\examples{
# will produce lints
lint(
  text = "foo <- function(x) return(y <- x + 1)",
  linters = function_return_linter()
)

lint(
  text = "foo <- function(x) return(x <<- x + 1)",
  linters = function_return_linter()
)

writeLines("e <- new.env() \nfoo <- function(x) return(e$val <- x + 1)")
lint(
  text = "e <- new.env() \nfoo <- function(x) return(e$val <- x + 1)",
  linters = function_return_linter()
)

# okay
lint(
  text = "foo <- function(x) return(x + 1)",
  linters = function_return_linter()
)

code_lines <- "
foo <- function(x) {
  x <<- x + 1
  return(x)
}
"
lint(
  text = code_lines,
  linters = function_return_linter()
)

code_lines <- "
e <- new.env()
foo <- function(x) {
  e$val <- x + 1
  return(e$val)
}
"
writeLines(code_lines)
lint(
  text = code_lines,
  linters = function_return_linter()
)

}
\seealso{
\link{linters} for a complete list of linters available in lintr.
}
\section{Tags}{
\link[=best_practices_linters]{best_practices}, \link[=readability_linters]{readability}
}
