% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/round-any.r
\name{round_any}
\alias{round_any}
\title{Round to multiple of any number.}
\usage{
round_any(x, accuracy, f = round)
}
\arguments{
\item{x}{numeric or date-time (POSIXct) vector to round}

\item{accuracy}{number to round to; for POSIXct objects, a number of seconds}

\item{f}{rounding function: \code{\link{floor}}, \code{\link{ceiling}} or
\code{\link{round}}}
}
\description{
Round to multiple of any number.
}
\examples{
round_any(135, 10)
round_any(135, 100)
round_any(135, 25)
round_any(135, 10, floor)
round_any(135, 100, floor)
round_any(135, 25, floor)
round_any(135, 10, ceiling)
round_any(135, 100, ceiling)
round_any(135, 25, ceiling)

round_any(Sys.time() + 1:10, 5)
round_any(Sys.time() + 1:10, 5, floor)
round_any(Sys.time(), 3600)
}
\keyword{manip}
