/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.expression;

import java.util.Enumeration;
import rene.zirkel.Zirkel;
import rene.zirkel.construction.Construction;
import rene.zirkel.construction.ConstructionException;
import rene.zirkel.construction.DepList;
import rene.zirkel.expression.BasicExpression;
import rene.zirkel.expression.ExpressionText;
import rene.zirkel.expression.ObjectExpression;
import rene.zirkel.expression.TopExpression;
import rene.zirkel.objects.ConstructionObject;

public class Expression {
    String S;
    BasicExpression E;
    boolean Valid;
    String ErrorText;
    DepList DL;
    double Value;
    boolean HasDoubleValue = false;
    boolean ForcePlus = false;

    public Expression(String string, Construction construction, ConstructionObject constructionObject, String[] stringArray, boolean bl) {
        if (string.startsWith("+")) {
            this.ForcePlus = true;
            string = string.substring(1);
        }
        this.S = string;
        this.DL = new DepList();
        try {
            ExpressionText expressionText = new ExpressionText(string, construction, constructionObject, this.DL, bl);
            expressionText.setVar(stringArray);
            this.E = TopExpression.scan(expressionText);
            if (expressionText.next() != '\u0000') {
                throw new ConstructionException(Zirkel.name("exception.superfluous"));
            }
            this.Valid = true;
        }
        catch (Exception exception) {
            this.Valid = false;
            this.ErrorText = exception.toString();
        }
    }

    public Expression(String string, Construction construction, ConstructionObject constructionObject, String[] stringArray) {
        this(string, construction, constructionObject, stringArray, false);
    }

    public Expression(String string, Construction construction, ConstructionObject constructionObject) {
        this(string, construction, constructionObject, null, false);
    }

    public boolean isValid() {
        return this.Valid;
    }

    public String getErrorText() {
        return this.ErrorText;
    }

    public double getValue() throws ConstructionException {
        if (this.HasDoubleValue) {
            return this.Value;
        }
        if (!this.Valid) {
            throw new ConstructionException(Zirkel.name("exception.expression"));
        }
        double d2 = this.E.getValue();
        if (Double.isNaN(d2) || Double.isInfinite(d2)) {
            throw new ConstructionException(Zirkel.name("exception.value"));
        }
        return d2;
    }

    public void setValue(double d2) {
        this.HasDoubleValue = true;
        this.ForcePlus = false;
        this.DL = new DepList();
        this.Value = d2;
    }

    public String toString() {
        if (this.HasDoubleValue) {
            return "" + this.Value;
        }
        if (this.Valid) {
            return this.E.toString();
        }
        return this.S;
    }

    public DepList getDepList() {
        return this.DL;
    }

    public void translate() {
        this.E.translate();
        this.DL.translate();
    }

    public boolean isNumber() {
        return this.HasDoubleValue || this.E.isNumber();
    }

    public void reset() {
        if (this.E != null && this.Valid) {
            this.E.reset();
        }
    }

    public boolean isForcePlus() {
        return this.ForcePlus;
    }

    public void setForcePlus(boolean bl) {
        this.ForcePlus = bl;
    }

    public ConstructionObject getObject() {
        if (this.E instanceof ObjectExpression) {
            return ((ObjectExpression)this.E).getObject();
        }
        return null;
    }

    public void addDep(ConstructionObject constructionObject) {
        Enumeration enumeration = this.getDepList().elements();
        while (enumeration.hasMoreElements()) {
            ConstructionObject.DL.add((ConstructionObject)enumeration.nextElement());
        }
    }
}

