/*
 * $Id: attribute.c,v 1.1 2000/08/07 22:23:57 emmerson Exp $
 */

/*LINTLIBRARY*/

#include "gks.h"
#include "xgks.h"

extern int	gks_errno;


    void
gset_line_ind(
    Gint   line_ind   /* polyline index   */)
{
    gks_errno	= gsetlineind(line_ind);
}



    void
gset_linetype(
    Gint   linetype   /* linetype   */)
{
    gks_errno	= gsetlinetype(linetype);
}



    void
gset_linewidth(
    Gfloat   linewidth   /* linewidth scale factor   */)
{
    gks_errno	= gsetlinewidth(linewidth);
}



    void
gset_line_colr_ind(
    Gint   line_colr_ind   /* polyline colour index   */)
{
    gks_errno	= gsetlinecolourind(line_colr_ind);
}



    void
gset_marker_ind(
    Gint   marker_ind   /* polymarker index   */)
{
    gks_errno	= gsetmarkerind(marker_ind);
}



    void
gset_marker_type(
    Gint   marker_type   /* marker type   */)
{
    gks_errno	= gsetmarkertype(marker_type);
}



    void
gset_marker_size(
    Gfloat   marker_size   /* marker size scale factor   */)
{
    gks_errno	= gsetmarkersize(marker_size);
}



    void
gset_marker_colr_ind(
    Gint   marker_colr_ind   /* polymarker colour index   */)
{
    gks_errno	= gsetmarkercolourind(marker_colr_ind);
}



    void
gset_text_ind(
    Gint   text_ind   /* text index   */)
{
    gks_errno	= gsettextind(text_ind);
}



    void
gset_text_font_prec(
    const Gtext_font_prec   *text_font_prec   /* text font and precision    */)
{
    gks_errno	= gsettextfontprec((Gtxfp*)text_font_prec);
}



    void
gset_char_expan(
    Gfloat   char_expan   /* character expansion factor   */)
{
}



    void
gset_char_space(
    Gfloat   char_space   /* character spacing   */)
{
}



    void
gset_text_colr_ind(
    Gint   text_colr_ind   /* text colour index   */)
{
}



    void
gset_char_ht(
    Gfloat   char_ht   /* character height   */)
{
}



    void
gset_char_up_vec(
    const Gvec   *char_up_vec   /* character up vector   */)
{
}



    void
gset_text_path(
    Gtext_path   text_path   /* text path   */)
{
}



    void
gset_text_align(
    const Gtext_align   *text_align   /* text alignment   */)
{
}



    void
gset_fill_ind(
    Gint   fill_ind   /* fill area index   */)
{
}



    void
gset_fill_int_style(
    Gfill_int_style   fill_int_style   /* fill area interior style   */)
{
}



    void
gset_fill_style_ind(
    Gint   fill_style_ind   /* fill area style index   */)
{
}



    void
gset_fill_colr_ind(
    Gint   fill_colr_ind   /* fill area colour index   */)
{
}



    void
gset_pat_size(
    const Gfloat_size   *pat_size   /* pattern size   */)
{
}



    void
gset_pat_ref_point_vecs(
    const Gpoint3   *pat_ref_point,   /* pattern reference point              */
    const Gvec3     pat_ref_vec[2]    /* 1st ref. vector: X axis of pattern   */
                                      /* 2nd ref. vector: Y axis of pattern   */)
{
}



    void
gset_pat_ref_point(
    const Gpoint   *pat_ref_point   /* pattern reference point   */)
{
}



    void
gset_edge_ind(
    Gint   edge_ind   /* edge index   */)
{
}



    void
gset_edge_flag(
    Gedge_flag   edge_flag   /* edge flag   */)
{
}



    void
gset_edgetype(
    Gint   edgetype   /* edgetype   */)
{
}



    void
gset_edgewidth(
    Gfloat   edgewidth   /* edgewidth scale factor   */)
{
}



    void
gset_edge_colr_ind(
    Gint   edge_colr_ind   /* edge colour index   */)
{
}



    void
gset_asfs3(
    const Gasfs3   *list_asf   /* list of aspect source flags    */)
{
}



    void
gset_asfs(
    const Gasfs   *list_asf   /* list of aspect source flags    */)
{
}



    void
gset_pick_id(
    Gint   pick_id   /* pick identifier   */)
{
}



    void
gset_line_rep(
    Gint                 ws_id,         /* workstation identifier     */
    Gint                 line_ind,      /* polyline index             */
    const Gline_bundle   *line_bundle   /* polyline representation    */)
{
}



    void
gset_marker_rep(
    Gint                   ws_id,           /* workstation identifier       */
    Gint                   marker_ind,      /* polymarker index             */
    const Gmarker_bundle   *marker_bundle   /* polymarker representation    */)
{
}



    void
gset_text_rep(
    Gint                 ws_id,         /* workstation identifier   */
    Gint                 text_ind,      /* text index               */
    const Gtext_bundle   *text_bundle   /* text representation      */)
{
}



    void
gset_fill_rep(
    Gint                 ws_id,         /* workstation identifier      */
    Gint                 fill_ind,      /* fill area index             */
    const Gfill_bundle   *fill_bundle   /* fill area representation    */)
{
}



    void
gset_pat_rep(
    Gint             ws_id,     /* workstation identifier    */
    Gint             pat_ind,   /* pattern index             */
    const Gpat_rep   *pat_rep   /* pattern representation    */)
{
}



    void
gset_edge_rep(
    Gint                 ws_id,         /* workstation identifier   */
    Gint                 edge_ind,      /* edge index               */
    const Gedge_bundle   *edge_bundle   /* edge representation      */)
{
}



    void
gset_colr_model(
    Gint   ws_id,       /* workstation identifier   */
    Gint   colr_model   /* colour model             */)
{
}



    void
gset_colr_rep(
    Gint              ws_id,      /* workstation identifier   */
    Gint              colr_ind,   /* colour index             */
    const Gcolr_rep   *colr_rep   /* colour representation    */)
{
}
