--
-- Tabella dei canali di chat
--
CREATE TABLE IF NOT EXISTS irc_channels (
  id INTEGER NOT NULL AUTO_INCREMENT,
  sol_id INTEGER NOT NULL,
  pol_id INTEGER NOT NULL,
  source_id INTEGER NOT NULL,
  capture_date TIMESTAMP NOT NULL DEFAULT '0000-00-00 00:00:00',
  decoding_date TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  viewed_date TIMESTAMP NOT NULL DEFAULT '0000-00-00 00:00:00',
  irc_id INTEGER NOT NULL REFERENCES ircs(id) ON DELETE CASCADE ON UPDATE CASCADE,
  first_visualization_user_id INTEGER DEFAULT 0,
  flow_info VARCHAR( 255 ) NOT NULL COMMENT 'Xml file of flow',
  channel VARCHAR( 255 ),
  end_date TIMESTAMP NOT NULL DEFAULT '0000-00-00 00:00:00',
  channel_path VARCHAR( 255 ),
  cusers VARCHAR( 255 ),
  cnick VARCHAR( 255 ),
  PRIMARY KEY (id),
  FOREIGN KEY (pol_id) REFERENCES pols(id) ON DELETE CASCADE,
  FOREIGN KEY (sol_id) REFERENCES sols(id) ON DELETE CASCADE,
  FOREIGN KEY (source_id) REFERENCES sources(id) ON DELETE CASCADE
) TYPE = MYISAM ;
